import cv2
import time

def read_http_stream(url):
    cap = cv2.VideoCapture(url)
    if not cap.isOpened(): 
        print("can't open capture")
        return None
    
    try:
        while True:
            ret, frame = cap.read()
            if not ret:
                print("帧丢失，尝试恢复...")
                cap.release()
                cap = cv2.VideoCapture(url)
                time.sleep(2)
                continue
            
            # 自定义处理逻辑（如保存帧）
            cv2.imshow('Stream', frame)
            if cv2.waitKey(1) & 0xFF == ord('q'):
                break
    except Exception as e:
        print(f"异常: {e}")
    finally:
        cap.release()
        cv2.destroyAllWindows()

if __name__ == "__main__":
    stream_url = "http://192.168.1.141:8899/video_feed"
    read_http_stream(stream_url)
